functions {

}


data {
  int<lower=1> N_obs;                               // number of observations
  int<lower=2> N_group;                             // number of groups
  int<lower=2> N_ind;                               // number of individuals

  int<lower=1,upper=N_group>  group[N_obs];         // group
  int<lower=1,upper=N_ind>    ID[N_obs];            // ID
  int<lower=0> days_tested[N_obs];                  // Number of days tested for gameto (Pfs25)
  int<lower=0> days_pos[N_obs];                     // Number of days positive for gameto (Pfs25)
}


transformed data{

}


parameters {
     real mu_group[N_group];          // mean proportion of days positve in each group (log-odds)
     real delta_ind[N_ind];           // individual-level deviations from the group mean (normalised)
     real<lower=0> delta_ind_sigma;   // standard deviation of individual-level deviations
}


transformed parameters {

}


model {
     vector[N_obs] p_pos_ind;         // Expected log-odds of days positive for each individual

  // Construct linear predictors
     for (i in 1:N_obs)  p_pos_ind[i] = mu_group[group[i]] + delta_ind_sigma * delta_ind[ID[i]];

  // =========================== //
  // Increment the log-posterior //
  // =========================== //

  // Priors
     // implicit: mu_group ~ improper uniform prior on the real plane
     delta_ind ~ normal(0, 1);  // normalised!!
     delta_ind_sigma ~ normal(0, 3);

  // Likelihood
     days_pos ~ binomial_logit(days_tested, p_pos_ind);
}


generated quantities {
     vector[N_group] mu_group_real;  // predicted mean proportion per group
     real p_group4_highest;
     real p_group4_higher_than_group12;
     real p_group3_higher_than_group12;
     real p_group1_higher_than_group2;
     real p_group4_higher_than_group3;
     real p_group34_highest;

     for (k in 1:N_group) mu_group_real[k] = inv_logit(mu_group[k]);

     p_group4_highest = 1;
     if (rank(mu_group, 4) <3) p_group4_highest = 0;

     // Stan manual on "rank":
     // int rank(vector v, int s)
     //     Number of components of v less than v[s]

     p_group4_higher_than_group12 = 1;
     if (mu_group[1] > mu_group[4] || mu_group[2] > mu_group[4]) p_group4_higher_than_group12 = 0;

     p_group3_higher_than_group12 = 1;
     if (mu_group[1] > mu_group[3] || mu_group[2] > mu_group[3]) p_group3_higher_than_group12 = 0;

     p_group1_higher_than_group2 = 1;
     if (mu_group[2] > mu_group[1]) p_group1_higher_than_group2 = 0;

     p_group4_higher_than_group3 = 1;
     if (mu_group[3] > mu_group[4]) p_group4_higher_than_group3 = 0;

     p_group34_highest = 1;  // probability that groups 3 and 4 are both higher than groups 1 and 2
     if (p_group4_higher_than_group12 == 0) p_group34_highest = 0;
     if (p_group3_higher_than_group12 == 0) p_group34_highest = 0;
}
